from flask import Flask, render_template, request
from flask_bootstrap import Bootstrap
from flask_wtf import FlaskForm
from wtforms import StringField, SubmitField
from wtforms.validators import DataRequired, Email
import requests

app = Flask(__name__)
app.config["SECRET_KEY"] = "your_secret_key"
Bootstrap(app)


class EmailForm(FlaskForm):
    email = StringField("Email", validators=[DataRequired(), Email()])
    submit = SubmitField("Check")


@app.route("/", methods=["GET", "POST"])
def index():
    form = EmailForm()
    result = None
    if form.validate_on_submit():
        email = form.email.data
        api_key = "your-api-key"
        response = requests.get(
            f"https://api.debounce.io/v1/?api={api_key}&email={email}"
        )
        result = response.json()["debounce"]["result"]
    return render_template("index.html", form=form, result=result)


if __name__ == "__main__":
    app.run(debug=True)
