from flask import Flask, jsonify
import requests
#from waitress import serve

app = Flask(__name__)


@app.route('/keywords/<prefix>', methods=['GET'])
def get_keywords(prefix):
    url = f"http://suggestqueries.google.com/complete/search?client=firefox&q={prefix}"
    response = requests.get(url).json()
    keywords = response[1]
    return jsonify(keywords)


def create_app():
    return app


if __name__ == '__main__':
    from os import environ
    port = int(environ.get('PORT', 8080))
    app.run(host='0.0.0.0', port=port)
#serve(app, threads=1)
