# Import necessary libraries
import streamlit as st
from SimplerLLM.language.llm import LLMProvider, LLM
from SimplerLLM.tools.generic_loader import load_content

# Initialize the language model instance
llm_instance = LLM.create(provider=LLMProvider.OPENAI, model_name="gpt-3.5-turbo")

# Title and introduction for the Streamlit app
st.title("Video Summary Generator")
st.write("Welcome to the Video Summary Generator! Please enter the URL of a YouTube video below, and this tool will generate a concise summary of the video content.")

# Sidebar for user input
# Users can input a YouTube video URL here
youtube_url = st.sidebar.text_input("Enter YouTube Video URL", "https://www.youtube.com/watch?v=Z-cESXv9KHY")

# Button to trigger the summary generation
if st.sidebar.button("Generate Summary"):
    # Show a message while loading content
    with st.spinner('Loading video content and generating summary...'):
        # Load the content of the youtube video
        video_script = load_content(youtube_url)

        # Generate a summary of the video
        # Here we call the LLM instance to generate a response based on the video script
        video_summary = llm_instance.generate_response(
            prompt=f"Generate a concise summary of the following video script as bullet points:\n{video_script}"
        )

        # Display the video summary in the main area of the app
        st.subheader("Video Summary")
        st.write(video_summary)
else:
    # This part is displayed before any action is taken using the sidebar button
    st.write("Please enter a URL and click the 'Generate Summary' button to see the video summary.")
